#pragma once
#include <string>
#include "Service.h"
#include "SimFile.h"

using std::string;

//////////////////////////////////////////////////////////////////////////////////////
#define __AT_MAX__		1024
#define	CR				'\x0D'
#define	LF				'\x0A'
/**********************/
/* Sim Access Command */
/**********************/
#define kTelSimReadBinaryCmd			176
#define kTelSimReadRecordCmd			178	
#define kTelSimGetResponseCmd			192 
#define kTelSimUpdateBinaryCmd			214
#define kTelSimUpdateRecordCmd			220 
#define kTelSimStatusCmd				242
//////////////////////////////////////////////////////////////////////////////////////
#ifdef DLLMANAGER_EXPORTS
	#define DLLMANAGER_API __declspec(dllexport)
#else
	#define DLLMANAGER_API __declspec(dllimport) 
#endif
//////////////////////////////////////////////////////////////////////////////////////
class DLLMANAGER_API CServiceSIM :	public CService
{
protected:
	CSimFile currentFile;
private:
	UInt16 PrvSimStringToUInt(const char *iSP, UInt8 iSize);
public:
	CServiceSIM(void);
	CServiceSIM(CDllManager* iDllManager);
	virtual ~CServiceSIM(void);

	virtual Bool Dispatch(CCmd* iCmdP);
	virtual void OnConfigChange(int configID);
	
	Bool CIMI(CCmd* iCmdP, Bool iSilentMode=0);
	Bool CSVM(CCmd* iCmdP, Bool iSilentMode=0);
	Bool CSIM(CCmd* iCmdP, Bool iSilentMode=0);
	Bool CRSM(CCmd* iCmdP, Bool iSilentMode=0);
};
